<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Ticket Reports</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous" />
    <style>
        #printable * {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }

        @page {
            size: letter;
            margin: 0.5in;
        }

        @media print {
            /* body {
                visibility: hidden;
            } */

            #printable {
                --header-height: 115px;
                --footer-height: 5px;
                visibility: visible;
            }

            .noPrint {
                display: none;
            }

            #printable .header,
            #printable .header-space {
                height: var(--header-height);
            }

            #printable .footer,
            #printable .footer-space {
                height: var(--footer-height);
            }

            #printable .header,
            #printable .footer {
                position: fixed;
                width: 100%;
                left: 0;
                right: 0;
            }

            #printable .header {
                height: var(--header-height);
                top: 0;
            }

            #printable .footer {
                height: var(--footer-height);
                bottom: 0;
            }

            #printable .summary,
            #printable .note {
                page-break-inside: avoid;
            }
        }
    </style>
</head>

<body>
    <div class="d-flex justify-content-end flex-wrap gap-2 row-gap-2 noPrint">
        <button onclick="window.print();" class="btn btn-outline-secondary" tabindex="0">
            <span><i class="bx bx-printer me-sm-1"></i></span>
            <span class="d-inline-block">Print</span>
        </button>
        <!-- <button class="btn btn-primary" tabindex="0">
            <span><i class="bx bx-file me-sm-1"></i></span>
            <span class="d-inline-block">Export as PDF</span>
        </button> -->
    </div>
    <div id="printable">
        <table class="w-100">
            <thead>
                <tr>
                    <td>
                        <div class="header-space">
                            <p class="text-center">
                                <span class="text-uppercase fw-bold">Arellano University</span><br />
                                <small class="fst-italic">2600 Legarda St., Sampaloc, Manila</small><br />
                                <span>www.auticket.com</span><br />
                            </p>
                            <p class="text-center text-uppercase">
                                <?= $title ?> <br />
                                <?= $branch ?>
                            </p>
                        </div>
                    </td>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <div class="content">
                            <div class="table-con my-4">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Name</th>
                                            <?php if (isset($branchColumn) && $branchColumn === true) : ?>
                                                <th scope="col">Campus</th>
                                            <?php endif ?>
                                            <th scope="col">Position</th>
                                            <th scope="col">Rqmts. Status</th>
                                            <th scope="col">Time Attended</th>
                                            <th scope="col">Early Time Leaved</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $rowCount = 0;
                                        $attendeesCount = 0;
                                        $unattendedCount = 0;
                                        $earlyLeavesCount = 0;
                                        ?>
                                        <?php foreach ($tickets as $ticket) : ?>
                                            <tr>
                                                <th scope="row"><?= ++$rowCount ?></th>
                                                <td>
                                                    <?= esc("{$ticket->first_name} {$ticket->last_name}") ?> <br />
                                                    <!-- <small><?= esc($ticket->email) ?></small> -->
                                                </td>
                                                <?php if (isset($branchColumn) && $branchColumn === true) : ?>
                                                    <td><?= esc($ticket->branch_name) ?></td>
                                                <?php endif ?>
                                                <td>
                                                    <span style="text-transform: uppercase;"><?= esc("{$ticket->department} {$ticket->position}") ?></span> <br />
                                                    <small><?= esc($ticket->year ? ($ticket->track ? "{$ticket->year}-{$ticket->track}" : "Grade {$ticket->year}") : $ticket->track ?? "") ?></small>
                                                </td>
                                                <td>
                                                    <?= $ticket->req_submitted ? "Submitted" : "Not Submitted" ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($ticket->date_attend) {
                                                        echo esc($ticket->date_attend);
                                                        $attendeesCount++;
                                                    } else {
                                                        echo '~';
                                                        $unattendedCount++;
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($ticket->date_leave) {
                                                        echo esc($ticket->date_leave);
                                                        $earlyLeavesCount++;
                                                    } else {
                                                        echo '~';
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="summary">
                                <table class="table mb-5" style="max-width: 300px">
                                    <tr>
                                        <th>Attendees</th>
                                        <td><?= $attendeesCount ?></td>
                                    </tr>
                                    <tr>
                                        <th>Did not attend</th>
                                        <td><?= $unattendedCount ?></td>
                                    </tr>
                                    <tr>
                                        <th>Total</th>
                                        <td><?= $rowCount ?></td>
                                    </tr>
                                    <tr>
                                        <th>Early Outs</th>
                                        <td><?= $earlyLeavesCount ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="note">
                                <p>Retrieved By</p>
                                <p>
                                    <?php $user = auth()->user() ?>
                                    <strong><?= esc("{$user?->first_name} {$user?->last_name}") ?></strong> <br />
                                    <small class="fst-italic"><?= $user?->getEmail() ?></small>
                                </p>
                            </div>
                        </div>
                    </td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td>
                        <div class="footer-space">&nbsp;</div>
                    </td>
                </tr>
            </tfoot>
        </table>
        <div class="footer"></div>
    </div>
</body>

</html>