<style>
    <?= preg_replace('#[\r\n\t ]+#', ' ', file_get_contents(__DIR__ . DIRECTORY_SEPARATOR . 'reports.css')) ?>
</style>

<div class="report-structure">
    <table>
        <thead>
            <tr>
                <td>
                    <div class="header-space">
                        <div class="text-center">
                            <p>
                                <span class="header-text">Arellano University</span><br />
                                <span class="caption">2600 Legarda St., Sampaloc, Manila</span><br />
                                <span><?= $weburl ?? '' ?></span>
                            </p>
                            <p>
                                <?= $event ?>
                            </p>
                            <p class="report-title">
                                <?= $title ?> <br />
                                <?= $branch ?>
                            </p>
                        </div>
                    </div>
                </td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <div class="content">
                        <div class="table-container">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <?php if ($branch === null) : ?>
                                            <th scope="col">Branch</th>
                                        <?php endif ?>
                                        <th scope="col">Position</th>
                                        <th scope="col">Rqmts.</th>
                                        <th scope="col">Time Attended/Leaved</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $rowCount = 0;
                                    $attendeesCount = 0;
                                    $unattendedCount = 0;
                                    $earlyLeavesCount = 0;
                                    ?>
                                    <?php if (!empty($tickets)) : foreach ($tickets as $ticket) : ?>
                                            <tr>
                                                <th scope="row"><?= ++$rowCount ?></th>
                                                <td>
                                                    <?= esc("{$ticket->first_name} {$ticket->last_name}") ?> <br />
                                                    <!-- <small><?= esc($ticket->email) ?></small> -->
                                                </td>
                                                <?php if ($branch === null) : ?>
                                                    <td scope="row"><?= esc($ticket->branch_name) ?></td>
                                                <?php endif ?>
                                                <td>
                                                    <span style="text-transform: uppercase;"><?= esc("{$ticket->department} {$ticket->position}") ?></span> <br />
                                                    <small><?= esc($ticket->year ? ($ticket->track ? "{$ticket->year}-{$ticket->track}" : "Grade {$ticket->year}") : $ticket->track ?? "") ?></small>
                                                </td>
                                                <td>
                                                    <?= $ticket->req_submitted ? "OK" : "N/A" ?>
                                                </td>
                                                <td>
                                                    <?php if ($ticket->date_attend) : $attendeesCount++ ?>
                                                        <span class="text-uppercase text-bold">Attd:</span> <?= date('Y-M-d | h:i:s A', strtotime($ticket->date_attend)) ?>
                                                        <br />
                                                        <?php if ($ticket->date_leave) : $earlyLeavesCount++ ?>
                                                            <span class="text-uppercase text-bold">Left:</span> <?= date('Y-M-d | h:i:s A', strtotime($ticket->date_leave)) ?>
                                                        <?php else : ?>
                                                            <span class="text-bold"><?= $ticket->date_attend ? 'Did Not Leaved Early' : '' ?></span>
                                                        <?php endif ?>
                                                    <?php else : $unattendedCount++ ?>
                                                        <span class="text-bold">Did Not Attend</span>
                                                    <?php endif ?>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                    <?php else : ?>
                                        <tr>
                                            <td colspan="<?= $branch === null ? 6 : 5 ?>" style="text-align: center;">No Data Found.</td>
                                        </tr>
                                    <?php endif ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="summary">
                            <table class="table">
                                <tr>
                                    <th>Attendees</th>
                                    <td><?= $attendeesCount ?></td>
                                </tr>
                                <tr>
                                    <th>Did not attend</th>
                                    <td><?= $unattendedCount ?></td>
                                </tr>
                                <tr>
                                    <th>Total</th>
                                    <td><?= $rowCount ?></td>
                                </tr>
                                <tr>
                                    <th>Early Outs</th>
                                    <td><?= $earlyLeavesCount ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="note hidden">
                            <p>Retrieved By</p>
                            <p>
                                <?php if (auth()->loggedIn() && $user = auth()->user()) : ?>
                                    <strong><?= esc("{$user->first_name} {$user->last_name}") ?></strong> <br />
                                    <small class="fst-italic"><?= $user->getEmail() ?></small>
                                <?php endif ?>
                            </p>
                        </div>
                    </div>
                </td>
            </tr>
        </tbody>
        <tfoot>
            <tr>
                <td>
                    <div class="footer-space">&nbsp;</div>
                </td>
            </tr>
        </tfoot>
    </table>
    <div class="footer hidden">
        <?= date('m/d/Y, h:i:s a') ?>
    </div>
</div>