<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Ticket List <?= $this->endSection() ?>

<?= $this->section('content') ?>

<?php $alertTypes = ['success' => 'success', 'error' => 'danger', 'warning' => 'warning'];
foreach ($alertTypes as $alert => $type) : if (session()->getFlashdata($alert)) : ?>

        <div class="alert alert-<?= $type ?> alert-dismissible my-3 border" role="alert">
            <?= session()->getFlashdata($alert) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>

<?php endif;
endforeach; ?>

<div class="card">
    <div class="card-header row align-items-center">
        <div class="col-md-auto text-center">
            <h4 class="card-title m-0">Ticket Management</h4>
        </div>
        <div class="col-md-auto ms-auto pt-3 pt-md-0">
            <div class="row flex-wrap">
                <form class="col" method="post">
                    <div class="input-group input-group-merge">
                        <button type="submit" class="input-group-text">
                            <i class="bx bx-search"></i>
                        </button>
                        <input type="search" name="search" class="form-control" placeholder="Search..." aria-label="Search..." value="<?= $search ?? '' ?>" autofocus />
                    </div>
                </form>
                <div class="col-auto">
                    <a href="<?= base_url('ticket/register') ?>" class="btn btn-primary" tabindex="0">
                        <span><i class="bx bx-plus me-sm-1"></i></span>
                        <span class="d-none d-sm-inline-block">Register Ticket</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table table-striped">
            <caption class="ms-4">Current Event: <?= $event['event_name'] ?? 'There is no currently active event found.' ?></caption>
            <thead>
                <tr>
                    <th>Ticket Number</th>
                    <th>Name</th>
                    <th>Branch</th>
                    <th>Position</th>
                    <th>Requirements</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>

                <?php if (!empty($tickets)) : foreach ($tickets as $ticket) : ?>

                        <tr>
                            <td>
                                <i class="fab fa-angular fa-lg text-danger me-3"></i>
                                <strong><?= $ticket->ticket_number ?></strong>
                            </td>
                            <td>
                                <div class="fw-bold">
                                    <?php $fullname = $ticket->first_name . ' ' . (!empty($ticket->middle_name) ? $ticket->middle_name[0] . '. ' : '') . $ticket->last_name ?>
                                    <?= empty(trim($fullname)) ? 'No Name' : $fullname ?>
                                </div>
                                <div><small><?= $ticket->email ?></small></div>
                                <div><small>ID: <?= $ticket->id_number ?></small></div>
                            </td>
                            <td><?= $ticket->branch_name ?></td>
                            <td>
                                <div class="fw-bold">
                                    <?= $position = strtoupper(($ticket->department ? $ticket->department . ' ' : '') . $ticket->position) ?>
                                </div>
                                <small>
                                    <?= $year_track = $ticket->year ? ($ticket->track ? "{$ticket->year}-{$ticket->track}" : "Grade {$ticket->year}") : $ticket->track ?>
                                </small>
                            </td>
                            <td>
                                <?= $requirements = $ticket->req_submitted ? '<span class="badge bg-success">Submitted</span>' : '<span class="badge bg-warning">Not Submitted</span>' ?>
                            </td>
                            <td>
                                <div class="dropdown position-static">
                                    <a role="button" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end m-0">
                                        <li>
                                            <a class="dropdown-item" href="ticket/edit/<?= $ticket->ticket_id ?>">
                                                <i class="bx bx-edit-alt me-1"></i>
                                                Edit
                                            </a>
                                        </li>
                                        <li>
                                            <button class="dropdown-item" data-bs-toggle="offcanvas" data-bs-target="#view_<?= $ticket->ticket_id ?>" aria-controls="offcanvasEnd">
                                                <i class='bx bx-info-circle me-1'></i>
                                                Details
                                            </button>
                                        </li>
                                        <li>
                                            <div class="dropdown-divider"></div>
                                        </li>
                                        <li>
                                            <button class="dropdown-item text-danger" data-toggle="delete" data-ticket-id="<?= $ticket->ticket_id ?>">
                                                <i class="bx bx-trash me-1"></i>
                                                Remove
                                            </button>
                                        </li>
                                    </ul>
                                </div>

                                <div class="offcanvas offcanvas-end text-wrap" tabindex="-1" id="view_<?= $ticket->ticket_id ?>" aria-labelledby="offcanvasEndLabel">
                                    <div class="offcanvas-header">
                                        <h5 id="offcanvasEndLabel" class="offcanvas-title">Ticket Details</h5>
                                        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                                    </div>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item px-4">
                                            <div class="row">
                                                <div class="col-auto">
                                                    <?php $raw_data = $event['event_code'] . '-' . $ticket->ticket_number; ?>
                                                    <img src="<?= generate_qr_code_data($raw_data, 150, true) ?>" alt="QR Code">
                                                </div>
                                                <div class="col">
                                                    <div class="mb-2">
                                                        <small>Event Code</small>
                                                        <div class="fw-bold"><?= $event['event_code'] ?></div>
                                                    </div>
                                                    <div class="mb-2">
                                                        <small>Ticket Number</small>
                                                        <div class="fw-bold"><?= $ticket->ticket_number ?></div>
                                                    </div>
                                                    <div class="mb-2">
                                                        <small>Branch</small>
                                                        <div class="fw-bold"><?= $ticket->branch_code ?></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item px-4 overflow-auto mb-2" style="max-height: calc(100vh - 340px);">
                                            <div class="mb-2">
                                                <small>Name</small>
                                                <div class="fw-bold"><?= $fullname ? $fullname : 'No Name' ?></div>
                                            </div>
                                            <div class="mb-2">
                                                <small>Email</small>
                                                <div class="fw-bold"><?= $ticket->email ? $ticket->email : 'No Email' ?></div>
                                            </div>
                                            <div class="mb-2">
                                                <small>LRN/Student/ID Number</small>
                                                <div class="fw-bold"><?= $ticket->id_number ? $ticket->id_number : 'No Valid ID' ?></div>
                                            </div>
                                            <div class="mb-2">
                                                <small>Position</small>
                                                <div class="fw-bold"><?= $position ? $position : '' ?></div>
                                            </div>
                                            <?php if (!empty(trim($year_track))) : ?>
                                                <div class="mb-2">
                                                    <small>Grade/Year/Course/Strand</small>
                                                    <div class="fw-bold"><?= $year_track ?></div>
                                                </div>
                                            <?php endif ?>
                                            <div class="mb-2">
                                                <small>Requirements Status</small>
                                                <div class="fw-bold"><?= $requirements ?></div>
                                            </div>
                                            <div class="mb-2">
                                                <small>Attended</small>
                                                <div class="fw-bold"><?= $ticket->date_attend ? $ticket->date_attend : 'Not Yet' ?></div>
                                            </div>
                                            <div class="mb-2">
                                                <small>Early Leaved</small>
                                                <div class="fw-bold"><?= $ticket->date_leave ? $ticket->date_leave : 'Did Not Leaved Early' ?></div>
                                            </div>
                                            <div class="mb-2">
                                                <small>Encoder</small>
                                                <div class="fw-bold">
                                                    <?= $ticket->creator_fullname ? $ticket->creator_fullname : 'No Name' ?>
                                                </div>
                                                <span class="rounded p-1 text-white bg-secondary">
                                                    <?= $ticket->creator_username ? "@{$ticket->creator_username}" : "No Username" ?>
                                                </span>
                                            </div>
                                            <div class="mb-2">
                                                <small>Date Encoded</small>
                                                <div class="fw-bold">
                                                    <?= $ticket->created_at ?>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item px-4">
                                            <div class="d-flex gap-2">
                                                <button type="button" class="btn btn-primary" data-bs-dismiss="offcanvas">Close
                                                </button>
                                                <button type="button" class="btn btn-outline-secondary" data-toggle="resend_qr" data-form-id="#resendqr_<?= $ticket->ticket_id ?>">Resend QR
                                                </button>
                                                <form method="post" id="resendqr_<?= $ticket->ticket_id ?>">
                                                    <input type="hidden" name="ticketNumber" value="<?= $ticket->ticket_number ?>" />
                                                    <input type="hidden" name="eventName" value="<?= $event['event_name'] ?>" />
                                                    <input type="hidden" name="eventCode" value="<?= $event['event_code'] ?>" />
                                                    <input type="hidden" name="name" value="<?= $ticket->first_name ?>" />
                                                    <input type="hidden" name="email" value="<?= $ticket->email ?>" />
                                                    <input type="hidden" name="bcc" value="" />
                                                </form>
                                                <div class="d-flex gap-2 ms-auto">
                                                    <!--
                                            <a
                                                href="ticket/edit/<?= $ticket->ticket_id ?>"
                                                class="btn btn-icon btn-outline-primary"
                                                title="Edit"
                                                >
                                                <span class="tf-icons bx bx-edit-alt"></span>
                                            </a>
                                            -->
                                                    <button type="button" class="btn btn-icon btn-outline-danger toggle-delete" title="Delete" data-toggle="delete" data-ticket-id="<?= $ticket->ticket_id ?>">
                                                        <span class="tf-icons bx bx-trash"></span>
                                                    </button>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>

                    <?php endforeach;
                else : ?>

                    <tr>
                        <td colspan="7" class="text-danger text-center">No data found in table.</td>
                    </tr>

                <?php endif ?>

            </tbody>
        </table>
    </div>
    <div class="card-footer pt-3 pb-1">
        <div id="pagination-links">
            <?= $pager ?? '' ?>
        </div>
    </div>
</div>

<?= $this->section('pageScripts') ?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {


        $('[data-toggle="delete"]').click(function() {

            let link = 'ticket/delete/' + $(this).attr('data-ticket-id');

            Swal.fire({
                title: `Remove Ticket?`,
                html: `Do you really want to remove this ticket? This cannot be undone.`,
                iconHtml: `<i class='bx bx-trash bx-tada text-danger' style='font-size: 5.5rem;'></i>`,
                buttonsStyling: false,
                customClass: {
                    icon: `border-0`,
                    confirmButton: `btn btn-outline-danger me-2`,
                    cancelButton: `btn btn-outline-secondary`
                },
                showCancelButton: true,
                confirmButtonText: `Yes, remove it`
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = link;
                }
            });
        });

        $('[data-toggle="resend_qr"]').click(function() {

            let formID = $(this).attr('data-form-id');
            let formDataArray = $(formID).serializeArray();
            let formData = {};
            formDataArray.forEach((field) => {
                formData[field.name] = field.value;
            });

            Swal.fire({
                title: `Resend QR Code?`,
                html: `Do you really want to resend the ticket QR Code to owner's email?`,
                iconHtml: `<i class='bx bx-qr bx-tada' style='font-size: 5.5rem;'></i>`,
                buttonsStyling: false,
                customClass: {
                    icon: `border-0`,
                    confirmButton: `btn btn-outline-primary me-2`,
                    cancelButton: `btn btn-outline-secondary`
                },
                showCancelButton: true,
                confirmButtonText: `Yes, resend it`,
                showLoaderOnConfirm: true,
                preConfirm: async () => {
                    try {
                        const response = await fetch('<?= base_url('ticket/resend_qr') ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify(formData)
                        });
                        if (!response.ok) {
                            console.error(await response.json());
                            return Swal.showValidationMessage(`Something went wrong`);
                        }
                        return response.json();
                    } catch (error) {
                        console.error(error);
                        Swal.showValidationMessage(`Request failed`);
                    }
                },
                allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: result.value.success ? `Resent Success!` : `Resent Failed!`,
                        text: result.value.data,
                        icon: result.value.success ? `success` : `error`,
                        buttonsStyling: false,
                        customClass: {
                            confirmButton: `btn btn-outline-primary`
                        }
                    })
                }
            });

        });

        function resend_qr(formID) {

            let formData = $(formID).serialize();

            $.ajax({
                url: '<?= base_url('ticket/find_and_validate') ?>',
                type: 'POST',
                dataType: 'json', //fix this!!!
                data: formData,
                success: function(result) {
                    if (result.success) {

                    } else {
                        alert('Something went wrong on resending qr. Please contact admin');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    alert('Something went wrong on resending qr. Please contact admin');
                }
            });
        }

    });
</script>

<?= $this->endSection() ?>


<?= $this->endSection() ?>