<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Branch List <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0">Add New User</h5>
            </div>
            <div class="card-body">
                <form action="<?= base_url('/users/store') ?>" method="post">
                    <?= csrf_field() ?>
                    <div style="max-width: 600px;">
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="firstname">First Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="firstname" class="form-control" id="firstname" placeholder="Juan" value="<?= old('firstname') ?>" autofocus />
                                <small class="text-danger"><?= isset($validation) ? display_error($validation, 'firstname') : '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="lastname">Last Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="lastname" class="form-control" id="lastname" placeholder="Dela Cruz" value="<?= old('lastname') ?>"  />
                                <small class="text-danger"><?= isset($validation) ? display_error($validation, 'lastname') : '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="email">Email</label>
                            <div class="col-sm-9">
                                <input type="email" name="email" class="form-control" id="email" placeholder="juan.delacruz@example.com" aria-label="juan.delacruz@example.com" value="<?= old('email') ?>"  />
                                <small class="text-danger"><?= isset($validation) ? display_error($validation, 'email') : '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="phone_number">Phone No</label>
                            <div class="col-sm-9">
                                <input type="tel" name="phone_number" class="form-control" id="phone_number" placeholder="658 799 8941" aria-label="658 799 8941" value="<?= old('phone_number') ?>" />
                                <small class="text-danger"><?= isset($validation) ? display_error($validation, 'phone_number') : '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="admin">Role</label>
                            <div class="col-sm-9">
                                <div class="form-check mb-2">
                                    <input name="role" class="form-check-input" type="radio" value="ADMIN" id="admin" checked required />
                                    <label class="form-check-label" for="admin">Admin</label>
                                </div>
                                <div class="form-check">
                                    <input name="role" class="form-check-input" type="radio" value="USER" id="user" <?= old('role') == 'USER' ? 'checked' : '' ?>  />
                                    <label class="form-check-label" for="user">User</label>
                                </div>
                                <small class="text-danger"><?= isset($validation) ? display_error($validation, 'role') : '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3 form-password-toggle">
                            <label class="col-sm-3 col-form-label" for="password">Password</label>
                            <div class="col-sm-9">
                                <div class="input-group input-group-merge">
                                    <input type="password" name="password" class="form-control" id="password" placeholder="············" value="<?= old('password') ?>"  />
                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                </div>
                                <small class="text-danger"><?= isset($validation) ? display_error($validation, 'password') : '' ?></small>
                            </div>
                        </div>
                        <div class="row justify-content-end">
                            <div class="col-sm-9">
                                <div class="d-flex align-items-center gap-2">
                                    <a href="<?= base_url('/users') ?>" class="btn btn-outline-secondary">Cancel</a>
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>